/*
 * Filename: F28004x_CLA_header.h
 */

#ifndef PS_CLA_H_
#define PS_CLA_H_

#ifndef DSP28_DATA_TYPES
#define NULL    (0)
#define DSP28_DATA_TYPES
typedef int                int16;
typedef long               int32;
typedef long long          int64;
typedef unsigned int       Uint16;
typedef unsigned long      Uint32;
typedef unsigned long long Uint64;
typedef float              float32;
typedef long double        float64;
#endif

#include "CLAmath.h"
/*
#define sin(A)		CLAsin(A)
#define	cos(A)		CLAcos(A)
#define	asin(A)		CLAasin(A)
#define	acos(A)		CLAacos(A)
#define	atan2(A,B)	CLAatan2(A,B)
#define	atan(A)		CLAatan(A)
#define	pow(A,B)	CLAexpN(B,A)
#define log(A)		CLAln(A)
#define log10(A)	CLAlog10(A)
#define sqrt(A)     CLAsqrt(A)
*/
#define	pow(A,B)	CLAexpN(B,A)

#define __fsat(A, B, C) (((A) > (B)) ? (B) : (((A) < (C)) ? (C) : (A)))


// F28x Cpu interrupt MASK
#define M__INT1  0x0001         // ADC A/B/C/D 1, XINT1/2, TINT0, IPC
#define M__INT2  0x0002         // Tripzone
#define M__INT3  0x0004         // PWM
#define M__INT4  0x0008         // Capture
#define M__INT5  0x0010         // eQep
#define M__INT6  0x0020         // SPI
#define M__INT7  0x0040         // DMA
#define M__INT8  0x0080         // SCI C/D
#define M__INT9  0x0100         // SCI A/B, CAN A/B, USB
#define M__INT10 0x0200         // ADC A/B/C/D 2/3/4
#define M__INT11 0x0400         // CLA
#define M__INT12 0x0800         // XINT3/4/5
#define M__INT13 0x1000         // TINT1
#define M__INT14 0x2000         // TINT2

typedef float DefaultType;
#define  PSM_EALLOW         asm(" MEALLOW")
#define  PSM_EDIS           asm(" MEDIS")


// Encoder
#define EQEP_QCLR(encoderNo) *((Uint16*)((uintptr_t)(0x511A - 0x40 + encoderNo * 0x40)))
#define EQEP_QPOSCNT(encoderNo) *((Uint16*)((uintptr_t)(0x5100 - 0x40 + encoderNo * 0x40)))
#define EQEP_QFLG(encoderNo) *((Uint16*)((uintptr_t)(0x5119 - 0x40 + encoderNo * 0x40)))

inline void PSM_EncEntryIntr(Uint16 encoderNo)
{
    EQEP_QCLR(encoderNo) = 0xffff;
}
inline Uint32 PSM_EncGetCount(Uint16 encoderNo)
{
    return EQEP_QPOSCNT(encoderNo);
}

inline Uint16 PSM_EncIsIntrStrobe(Uint16 encoderNo)
{
    return EQEP_QFLG(encoderNo) & 0x200;
//  return EQep1Regs.QFLG.bit.SEL;
}

inline Uint16 PSM_EncIsIntrIndex(Uint16 encoderNo)
{
    return EQEP_QFLG(encoderNo) & 0x400;
//  return EQep1Regs.QFLG.bit.IEL;
}

// Capture
#define CAPINTR_EVT1    2
#define CAPINTR_EVT2    4
#define CAPINTR_PRD     0x80
#define ECAP_ECCTL1(capNo)  ((*(Uint16*)((uintptr_t)(0x5214 - 0x40 + 0x40 * capNo))) & 1)    // ECCTL1.CAP1POL
#define	ECAP_CAP1(capNo)	(*(Uint32*)((uintptr_t)(0x5204 - 0x40 + 0x40 * capNo)))
#define	ECAP_CAP2(capNo)	(*(Uint32*)((uintptr_t)(0x5206 - 0x40 + 0x40 * capNo)))
#define	ECAP_EVT1(capNo)	((*(Uint16*)((uintptr_t)(0x5217 - 0x40 + 0x40 * capNo))) & CAPINTR_EVT1)
#define	ECAP_EVT2(capNo)	((*(Uint16*)((uintptr_t)(0x5217 - 0x40 + 0x40 * capNo))) & CAPINTR_EVT2)
#define	ECAP_ECCLR(capNo)	(*(Uint16*)((uintptr_t)(0x5218 - 0x40 + 0x40 * capNo)))
#define	ECAP_CTRPHS(capNo)	(*(Uint32*)((uintptr_t)(0x5202 - 0x40 + 0x40 * capNo)))
#define ECAP_ECEINT(capNo)  ((*(Uint16*)((uintptr_t)(0x5216 - 0x40 + 0x40 * capNo))) & (CAPINTR_EVT1 | CAPINTR_EVT2))

inline Uint32 PSM_CapIsRisingEdge(Uint16 capNo)
{
    return (ECAP_ECEINT(capNo) == (CAPINTR_EVT1 | CAPINTR_EVT2)) ? (ECAP_EVT1(capNo) >> 1) : !ECAP_ECCTL1(capNo);
}

inline Uint32 PSM_CapGetCurCount(Uint16 capNo)
{
    return ECAP_EVT1(capNo) ? ECAP_CAP1(capNo) : ECAP_CAP2(capNo);
}
inline DefaultType PSM_CapGetCurTime(Uint16 capNo, DefaultType timeUint)
{
    return PSM_CapGetCurCount(capNo) * timeUint;
}

inline void PSM_CapEntryIntr()
{
}

inline void PSM_CapExitIntr(Uint16 capNo)
{
	ECAP_ECCLR(capNo) = (Uint16)0xff;
}

inline void PSM_CapPwmSetPhase(Uint16 pwmNo, float phaseShifted)
{
    ECAP_CTRPHS(pwmNo) = (Uint32)(__mfracf32(__mfracf32(phaseShifted ) + 1.0) * ECAP_CAP1(pwmNo));
}


#define PSM_GpioData(grpNo) *((Uint32*)((uintptr_t)(0x7F00 + 8 * (grpNo))))	// For AIOs grpNo is 7
#define PSM_GpioSet(grpNo) *((Uint32*)((uintptr_t)(0x7F02 + 8 * (grpNo))))
#define PSM_GpioClear(grpNo) *((Uint32*)((uintptr_t)(0x7F04 + 8 * (grpNo))))

inline void PSM_GpioSetOutput(int16 pinNo, int16 val)
{
    if (val != 0) {
        PSM_GpioSet(pinNo>>5) = (Uint32)1 << (pinNo & 31);
    } else {
        PSM_GpioClear(pinNo>>5) = (Uint32)1 << (pinNo & 31);
    }
}

inline Uint16 PSM_GpioGetInput(int16 pinNo)
{
    return (PSM_GpioData(pinNo>>5)&((Uint32)1 << (pinNo & 31))) ? 1 : 0;
}

inline Uint16 PSM_DigitInGetValue(int16 chnNo)
{
    return PSM_GpioData(chnNo >> 5) & (1UL << (chnNo & 31));
}

inline void PS_ExtIntrHighEntry(void)
{
}

inline void PS_ExtIntrLowEntry(void)
{
}

inline void PSM_DigitOutSetValue(int16 chnNo, DefaultType value)
{
    Uint32 *pReg = (Uint32*)((uintptr_t)(8 * (chnNo >> 5) + ((value > 0.3) ? 0x7F02 : 0x7F04)));
    *pReg |= (Uint32)1 << (chnNo & 31);
}

inline void PSM_InXBarHighIntrEntry()
{
}

inline void PSM_InXBarLowIntrEntry()
{
}

#define PWM_TBPRD(_p)       *((Uint16 *)((uintptr_t)(0x3F63 + 0x100 * (_p))))
#define PWM_CMPA(_p)        *((Uint16 *)((uintptr_t)(0x3F6B + 0x100 * (_p))))
#define PWM_CMPAHR(_p)      *((Uint16 *)((uintptr_t)(0x3F6A + 0x100 * (_p))))
#define PWM_CMPB(_p)        *((Uint16 *)((uintptr_t)(0x3F6D + 0x100 * (_p))))
#define PWM_CMPBHR(_p)      *((Uint16 *)((uintptr_t)(0x3F6C + 0x100 * (_p))))
#define PWM_TBPHS(_p)       *((Uint16 *)((uintptr_t)(0x3F61 + 0x100 * (_p))))
#define PWM_TBCTL(_p)       *((Uint16 *)((uintptr_t)(0x3F00 + 0x100 * (_p))))
#define PWM_TBCTL2(_p)      *((Uint16 *)((uintptr_t)(0x3F01 + 0x100 * (_p))))
#define PWM_TZCLR(_p)       *((Uint16 *)((uintptr_t)(0x3F97 + 0x100 * (_p))))
#define PWM_TZFRC(_p)       *((Uint16 *)((uintptr_t)(0x3F9B + 0x100 * (_p))))
#define PWM_TZCBCCLR(_p)    *((Uint16 *)((uintptr_t)(0x3F98 + 0x100 * (_p))))
#define PWM_TZOSTCLR(_p)    *((Uint16 *)((uintptr_t)(0x3F98 + 0x100 * (_p))))
#define PWM_TZFLG(_p)       *((Uint16 *)((uintptr_t)(0x3F93 + 0x100 * (_p))))
#define PWM_ETCLR(_p)       *((Uint16 *)((uintptr_t)(0x3FAA + 0x100 * (_p))))

inline void PSM_PwmIntrEntry(int pwmNo)
{
    PWM_ETCLR(pwmNo) |= 1; // PwmReg.ETCLR.bit.INT = 1;
}

inline Uint16 PSM_PwmIsOneShotTz(int16 pwmNo)
{
    return PWM_TZFLG(pwmNo) & 0x2c;
}

inline void PSM_PwmTzIntrEntry(int16 pwmNo)
{
}

inline void PSM_PwmTzCbcReset(int16 pwmNo)
{
	PSM_EALLOW;
	PWM_TZCLR(pwmNo) = 3; // PwmReg.TZCLR.bit.CBC = 1; PwmReg.TZCLR.bit.INT = 1;
	PSM_EDIS;
}

inline void PSM_PwmStop(int16 pwmNo)
{
    PSM_EALLOW;
    PWM_TZFRC(pwmNo) = 4;
    PSM_EDIS;
}

inline void PSM_Pwm3phStop(int16 pwmNo)
{
    PSM_EALLOW;
    PWM_TZFRC(pwmNo * 3 - 2) = 4;
    PWM_TZFRC(pwmNo * 3 - 1) = 4;
    PWM_TZFRC(pwmNo * 3) = 4;
    PSM_EDIS;
}

inline void PSM_PwmStart(int16 pwmNo)
{
    PSM_EALLOW;
    PWM_TZCLR(pwmNo) = (PWM_TZCLR(pwmNo) & 0xC000) | 4;
    PSM_EDIS;
}

inline void PSM_Pwm3phStart(int16 pwmNo)
{
    PSM_EALLOW;
    PWM_TZCLR(pwmNo * 3 - 2) = PWM_TZCLR(pwmNo * 3 - 1) = PWM_TZCLR(pwmNo * 3) = (PWM_TZCLR(pwmNo * 3 - 2) & 0xC000) | 4;
    PSM_EDIS;
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
// Adc_F28004x.c definitions

#define ADC_CLR(_a) *((Uint16 *)(0x7404 + 0x80 * _a))

#define ADC_RESULT(_adc,_soc)   *((Uint16 *)(0x0B00 + 0x20*_adc + _soc))


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
// Comp_F28004x.c definitions
#define CMP_RAMPMAXREF(_ch)     *((Uint16 *)((uintptr_t)(0x5C6A + 0x20 * _ch)))
#define CMP_RAMPDECVAL(_ch)     *((Uint16 *)((uintptr_t)(0x5C6E + 0x20 * _ch)))
#define CMP_DACH(_ch)           *((Uint16 *)((uintptr_t)(0x5C66 + 0x20 * _ch)))
#define CMP_DACL(_ch)           *((Uint16 *)((uintptr_t)(0x5C72 + 0x20 * _ch)))

inline void PSM_CompDacHSetValue(int16 compNo, int32 dacVolt)
{
    CMP_DACH(compNo) = __mmaxf32(__mminf32(dacVolt, 4095), 0);
}
inline void PSM_CompDacLSetValue(int16 compNo, int32 dacVolt)
{
    CMP_DACL(compNo) = __mmaxf32(__mminf32(dacVolt, 4095), 0);
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
// Dac_F28004x.c definitions

#define DACVALS(dacNo) *((Uint16*)((uintptr_t)(0x5c03 - 0x10 + dacNo * 0x10)))
inline void PSM_DacSetValue(int dacNo, int32 val)
{
    DACVALS(dacNo) = __mmaxf32(__mminf32(val, 4095), 0);
}



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
// PGA_F28004x.c definitions
#define PGA_CTLREG(pgaNo) *((Uint32*)((uintptr_t)(0x5B0F - 0x10 + pgaNo * 0x10)))
#define PGA_SETGAIN(pgaNo, val) {PGA_CTLREG(pgaNo) &= ~((Uint32)0xe0);PGA_CTLREG(pgaNo) |= __mmaxf32(__mminf32(val, 3), 0) << 5;}


// F28004x SDFM
#define ERRFLG_SDFM_IEL     1       // Allow IEL interrupt
#define ERRFLG_SDFM_IEH     2       // Allow IEH interrupt
typedef void (*PST_SdfmErrVec)(Uint32 errFlag);
#define	PSM_SDFM_FifoData(FiltNo) *((int32*)((uintptr_t)((0x5E18 - 0x10) + 0x10 * FiltNo)))
#define PSM_SDFM_Data16(FiltNo) *((int16*)((uintptr_t)((0x5E17 - 0x10) + 0x10 * FiltNo)))
#define PSM_SDFM_Data32(FiltNo) *((int32*)((uintptr_t)((0x5E16 - 0x10) + 0x10 * FiltNo)))
#define	PSM_SDFM_SDIFlag()	*((Uint32*)((uintptr_t)0x5E00))
inline void PSM_SDFM_FifoFlagClr(Uint32 flgClr) {
    *((Uint32*)((uintptr_t)0x5E02)) = flgClr;
}
inline int PSM_SDFM_FifoIntrReady(Uint32 FiltBits) {
	FiltBits = (FiltBits & 15) << 20;
	return ((FiltBits & PSM_SDFM_SDIFlag()) == FiltBits) ? 1 : 0;
}
#endif /* PS_CLA_H_ */
